SELECT tl.request_session_id AS session_id,
       DB_NAME(tl.resource_database_id) AS nom_base,
       tl.resource_type AS type_ressource,
       CASE
          WHEN tl.resource_type IN ('BASE', 'FICHIER', 'MTADONNES')
             THEN tl.resource_type
          WHEN tl.resource_type = 'OBJET'
             THEN OBJECT_NAME(tl.resource_associated_entity_id, tl.resource_database_id)
          WHEN tl.resource_type IN ('CLEF', 'PAGE', 'LIGNE')
             THEN (SELECT OBJECT_NAME(object_id)
			       FROM   sys.partitions AS p
                   WHERE p.hobt_id = tl.resource_associated_entity_id)
          ELSE 'Inconnu'
       END AS objet_parent,
       tl.request_mode AS type_verrou,
       tl.request_status AS statut_requete,
       er.blocking_session_id AS id_session_bloquante,
       es.login_name,
       CASE tl.request_lifetime
          WHEN 0
             THEN sql_a.text
          ELSE sql_r.text
       END AS commande_SQL
FROM   sys.dm_tran_locks AS tl
       LEFT OUTER JOIN sys.dm_exec_requests AS er
            ON tl.request_session_id = er.session_id
       INNER JOIN sys.dm_exec_sessions AS es
            ON tl.request_session_id = es.session_id
       INNER JOIN sys.dm_exec_connections AS ec
            ON tl.request_session_id = ec.most_recent_session_id
       OUTER APPLY sys.dm_exec_sql_text(ec.most_recent_sql_handle) AS sql_r
       OUTER APPLY sys.dm_exec_sql_text(er.sql_handle) AS sql_a
WHERE  tl.resource_database_id = DB_ID()
  AND  tl.resource_type NOT IN ('DATABASE', 'METADATA')
ORDER  BY tl.request_session_id;